/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.common.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.minecraftabnormals.endergetic.common.world.features.EEFeatures;
import com.minecraftabnormals.endergetic.common.world.features.EndergeticEndPodiumFeature;
import com.minecraftabnormals.endergetic.core.config.EEConfig;
import com.minecraftabnormals.endergetic.core.registry.EEBlocks;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.EndPortalTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Unit;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.end.DragonFightManager;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class EndergeticDragonFightManager
extends DragonFightManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Predicate<Entity> VALID_PLAYER = EntityPredicates.field_94557_a.and(EntityPredicates.func_188443_a((double)0.0, (double)128.0, (double)0.0, (double)192.0));

    public EndergeticDragonFightManager(ServerWorld worldIn, long seed, CompoundNBT compound) {
        super(worldIn, seed, compound);
    }

    public void func_186105_b() {
        this.field_186109_c.func_186758_d(!this.field_186117_k);
        if (this.field_186116_j++ >= 20) {
            this.updatePlayers();
            this.field_186116_j = 0;
        }
        if (!this.field_186109_c.func_186757_c().isEmpty()) {
            this.field_186110_d.func_72863_F().func_217228_a(TicketType.field_219489_b, new ChunkPos(0, 0), 9, (Object)Unit.INSTANCE);
            boolean flag = this.func_222670_k();
            if (this.field_186120_n && flag) {
                this.scanForLegacyFight();
                this.field_186120_n = false;
            }
            if (this.field_186122_p != null) {
                if (this.field_186124_r == null && flag) {
                    this.field_186122_p = null;
                    this.func_186106_e();
                }
                this.field_186122_p.func_186079_a(this.field_186110_d, (DragonFightManager)this, this.field_186124_r, this.field_186123_q++, this.field_186121_o);
            }
            if (!this.field_186117_k) {
                if ((this.field_186119_m == null || ++this.field_186113_g >= 1200) && flag) {
                    this.func_210828_h();
                    this.field_186113_g = 0;
                }
                if (++this.field_186115_i >= 100 && flag) {
                    this.func_186101_k();
                    this.field_186115_i = 0;
                }
            }
        } else {
            this.field_186110_d.func_72863_F().func_217222_b(TicketType.field_219489_b, new ChunkPos(0, 0), 9, (Object)Unit.INSTANCE);
        }
        if (EEConfig.ValuesHolder.shouldDebugDragonFightManager()) {
            LOGGER.debug("Found exit portal: " + this.findEndergeticExitPortal(true));
            LOGGER.debug(this.field_186121_o != null ? this.field_186121_o.toString() : "null");
        }
    }

    private void scanForLegacyFight() {
        LOGGER.info("Scanning for legacy world dragon fight...");
        boolean flag = this.exitPortalExists();
        if (flag) {
            LOGGER.info("Found that the dragon has been killed in this world already.");
            this.field_186118_l = true;
        } else {
            LOGGER.info("Found that the dragon has not yet been killed in this world.");
            this.field_186118_l = false;
            if (!this.findEndergeticExitPortal(false)) {
                this.func_186094_a(false);
            }
        }
        List list = this.field_186110_d.func_217439_j();
        if (list.isEmpty()) {
            this.field_186117_k = true;
        } else {
            EnderDragonEntity enderdragonentity = (EnderDragonEntity)list.get(0);
            this.field_186119_m = enderdragonentity.func_110124_au();
            LOGGER.info("Found that there's a dragon still alive ({})", (Object)enderdragonentity);
            this.field_186117_k = false;
            if (!flag) {
                LOGGER.info("But we didn't have a portal, let's remove it.");
                enderdragonentity.func_70106_y();
                this.field_186119_m = null;
            }
        }
        if (!this.field_186118_l && this.field_186117_k) {
            this.field_186117_k = false;
        }
    }

    private void updatePlayers() {
        HashSet set = Sets.newHashSet();
        for (ServerPlayerEntity serverplayerentity : this.field_186110_d.func_217490_a(VALID_PLAYER)) {
            this.field_186109_c.func_186760_a(serverplayerentity);
            set.add(serverplayerentity);
        }
        HashSet set1 = Sets.newHashSet((Iterable)this.field_186109_c.func_186757_c());
        set1.removeAll(set);
        for (ServerPlayerEntity serverplayerentity1 : set1) {
            this.field_186109_c.func_186761_b(serverplayerentity1);
        }
    }

    private boolean exitPortalExists() {
        for (int i = -8; i <= 8; ++i) {
            for (int j = -8; j <= 8; ++j) {
                Chunk chunk = this.field_186110_d.func_212866_a_(i, j);
                for (TileEntity tileentity : chunk.func_177434_r().values()) {
                    if (!(tileentity instanceof EndPortalTileEntity)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void func_186106_e() {
        if (this.field_186117_k && this.field_186122_p == null) {
            BlockPos portalPos = this.field_186121_o;
            if (portalPos == null) {
                LOGGER.debug("Tried to respawn, but need to find the portal first.");
                if (!this.findEndergeticExitPortal(false)) {
                    LOGGER.debug("Couldn't find a portal, so we made one.");
                    this.func_186094_a(true);
                } else {
                    LOGGER.debug("Found the exit portal & temporarily using it.");
                }
                portalPos = this.field_186121_o;
            }
            ArrayList list1 = Lists.newArrayList();
            BlockPos centerPos = portalPos.func_177981_b(2);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                List list = this.field_186110_d.func_217357_a(EnderCrystalEntity.class, new AxisAlignedBB(centerPos.func_177967_a(direction, 2)));
                if (list.isEmpty()) {
                    return;
                }
                list1.addAll(list);
            }
            LOGGER.debug("Found all crystals, respawning dragon.");
            this.func_186093_a(list1);
        }
    }

    @Nullable
    public BlockPattern.PatternHelper func_186091_h() {
        return null;
    }

    public boolean findEndergeticExitPortal(boolean debug) {
        int height;
        for (int i = -8; i <= 8; ++i) {
            for (int j = -8; j <= 8; ++j) {
                Chunk chunk = this.field_186110_d.func_212866_a_(i, j);
                for (TileEntity tileentity : chunk.func_177434_r().values()) {
                    if (!(tileentity instanceof EndPortalTileEntity)) continue;
                    BlockPos tilePos = tileentity.func_174877_v();
                    for (Direction directions : Direction.Plane.HORIZONTAL) {
                        BlockPos possiblePortalPos;
                        if (this.field_186110_d.func_180495_p(tilePos.func_177972_a(directions)).func_177230_c() != EEBlocks.MYSTICAL_OBSIDIAN.get() || !this.isPortalAtPos(possiblePortalPos = tilePos.func_177972_a(directions).func_177977_b())) continue;
                        if (!debug) {
                            this.field_186121_o = possiblePortalPos;
                        }
                        return true;
                    }
                }
            }
        }
        for (int y = height = this.field_186110_d.func_205770_a(Heightmap.Type.MOTION_BLOCKING, EndergeticEndPodiumFeature.END_PODIUM_LOCATION.func_177984_a()).func_177956_o(); y >= 0; --y) {
            BlockPos pos = new BlockPos(EndergeticEndPodiumFeature.END_PODIUM_LOCATION.func_177958_n(), y, EndergeticEndPodiumFeature.END_PODIUM_LOCATION.func_177952_p());
            if (!this.isPortalAtPos(pos)) continue;
            if (!debug) {
                this.field_186121_o = pos;
            }
            return true;
        }
        return false;
    }

    private boolean isPortalAtPos(BlockPos pos) {
        BlockPos up = pos.func_177984_a();
        ServerWorld world = this.field_186110_d;
        boolean[] flag = new boolean[4];
        for (Direction directions : Direction.Plane.HORIZONTAL) {
            BlockPos side = up.func_177967_a(directions, 3);
            if (world.func_180495_p(side).func_177230_c() != EEBlocks.MYSTICAL_OBSIDIAN_ACTIVATION_RUNE.get() && world.func_180495_p(side).func_177230_c() != EEBlocks.ACTIVATED_MYSTICAL_OBSIDIAN_ACTIVATION_RUNE.get() || world.func_180495_p(side.func_177972_a(directions.func_176746_e())).func_177230_c() != EEBlocks.MYSTICAL_OBSIDIAN_RUNE.get() || world.func_180495_p(side.func_177972_a(directions.func_176735_f())).func_177230_c() != EEBlocks.MYSTICAL_OBSIDIAN_RUNE.get() || world.func_180495_p(up).func_177230_c() != EEBlocks.MYSTICAL_OBSIDIAN.get() || world.func_180495_p(up.func_177964_d(2).func_177965_g(2)).func_177230_c() != EEBlocks.MYSTICAL_OBSIDIAN.get() || world.func_180495_p(up.func_177964_d(2).func_177985_f(2)).func_177230_c() != EEBlocks.MYSTICAL_OBSIDIAN.get() || world.func_180495_p(up.func_177970_e(2).func_177965_g(2)).func_177230_c() != EEBlocks.MYSTICAL_OBSIDIAN.get() || world.func_180495_p(up.func_177970_e(2).func_177985_f(2)).func_177230_c() != EEBlocks.MYSTICAL_OBSIDIAN.get()) continue;
            flag[directions.func_176745_a() - 2] = true;
        }
        return flag[0] && flag[1] && flag[2] && flag[3];
    }

    public void func_186096_a(EnderDragonEntity dragon) {
        if (dragon.func_110124_au().equals(this.field_186119_m)) {
            this.field_186109_c.func_186735_a(0.0f);
            this.field_186109_c.func_186758_d(false);
            this.func_186094_a(true);
            this.func_186097_l();
            if (!this.field_186118_l) {
                this.field_186110_d.func_175656_a(this.field_186110_d.func_205770_a(Heightmap.Type.MOTION_BLOCKING, EndergeticEndPodiumFeature.END_PODIUM_LOCATION), Blocks.field_150380_bt.func_176223_P());
            }
            this.field_186118_l = true;
            this.field_186117_k = true;
        }
    }

    public void func_186094_a(boolean active) {
        EndergeticEndPodiumFeature endpodium = new EndergeticEndPodiumFeature(active);
        if (this.field_186121_o == null) {
            this.field_186121_o = this.field_186110_d.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EndergeticEndPodiumFeature.END_PODIUM_LOCATION).func_177977_b();
            while (this.field_186110_d.func_180495_p(this.field_186121_o).func_177230_c() == Blocks.field_150357_h && this.field_186121_o.func_177956_o() > this.field_186110_d.func_181545_F()) {
                this.field_186121_o = this.field_186121_o.func_177977_b();
            }
        }
        endpodium.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_242765_a((ISeedReader)this.field_186110_d, this.field_186110_d.func_72863_F().func_201711_g(), new Random(), this.field_186121_o);
    }

    protected void func_186097_l() {
        List gateways = (List)ObfuscationReflectionHelper.getPrivateValue(DragonFightManager.class, (Object)((Object)this), (String)"field_186111_e");
        if (!gateways.isEmpty()) {
            int removed = (Integer)gateways.remove(gateways.size() - 1);
            BlockPos pos = new BlockPos(MathHelper.func_76128_c((double)(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)removed)))), 75, MathHelper.func_76128_c((double)(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)removed)))));
            this.field_186110_d.func_217379_c(3000, pos, 0);
            EEFeatures.Configured.END_GATEWAY_DELAYED.func_242765_a((ISeedReader)this.field_186110_d, this.field_186110_d.func_72863_F().func_201711_g(), new Random(), pos);
        }
    }
}

